VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "MeasurementBlock"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Member0" ,"Sample"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
' This data type stores all the data fields measured in one
' pass of measurement in the magnetometer.
    
' Baseline measurements
Private mvarBaselines(1 To 2) As Cartesian3D
    
' Sample measurements
Private mvarSample(1 To 4) As Cartesian3D
Private mvarHolder(1 To 4) As Cartesian3D
Private mvarDirection As Integer

Public Sub SetSample(ByVal i As Integer, ByVal measurement As Cartesian3D)
    Set mvarSample(i) = measurement
End Sub

Public Property Get Sample(ByVal i As Integer) As Cartesian3D
    Set Sample = mvarSample(i)
End Property

Public Sub SetBaseline(ByVal i As Integer, ByVal measurement As Cartesian3D)
    Set mvarBaselines(i) = measurement
End Sub

Public Property Get Baselines(ByVal i As Integer) As Cartesian3D
    Set Baselines = mvarBaselines(i)
End Property


Public Property Let isUp(ByVal vdata As Boolean)
    If vdata Then
        mvarDirection = 1
    Else
        mvarDirection = -1
    End If
End Property

Public Property Get isUp() As Boolean
    isUp = (mvarDirection = 1)
End Property


Private Sub Class_Initialize()
    'creates the collection when this class is created
    Dim i As Integer
    For i = 1 To 4
        Set mvarSample(i) = New Cartesian3D
        Set mvarHolder(i) = New Cartesian3D
    Next i
    For i = 1 To 2
        Set mvarBaselines(i) = New Cartesian3D
    Next i
    mvarDirection = 1
End Sub

Private Sub Class_Terminate()
    'creates the collection when this class is created
    Dim i As Integer
    For i = 1 To 4
        Set mvarSample(i) = Nothing
        Set mvarHolder(i) = Nothing
    Next i
    For i = 1 To 2
        Set mvarBaselines(i) = Nothing
    Next i
End Sub


Public Sub SetHolder(ByVal i As Integer, ByVal vdata As Cartesian3D)
    Set mvarHolder(i) = vdata
End Sub

Public Property Get Holder(ByVal i As Integer) As Cartesian3D
    If i < 1 Or i > 4 Then Exit Property
    Set Holder = mvarHolder(i)
End Property

Public Property Get BaselineAdjustedSample(ByVal i As Integer) As Cartesian3D
    Dim BaselineFactor(1 To 2) As Single
    
    BaselineFactor(1) = 1 - i / 5
    BaselineFactor(2) = i / 5

    If i < 1 Or i > 4 Then Exit Property
    
    Set BaselineAdjustedSample = New Cartesian3D
    With BaselineAdjustedSample
        .x = mvarSample(i).x - BaselineFactor(1) * mvarBaselines(1).x - BaselineFactor(2) * mvarBaselines(2).x - mvarHolder(i).x
        .y = mvarSample(i).y - BaselineFactor(1) * mvarBaselines(1).y - BaselineFactor(2) * mvarBaselines(2).y - mvarHolder(i).y
        .z = mvarSample(i).z - BaselineFactor(1) * mvarBaselines(1).z - BaselineFactor(2) * mvarBaselines(2).z - mvarHolder(i).z
    End With
End Property

Public Property Get driftc() As Cartesian3D
    Set driftc = New Cartesian3D
    driftc.x = mvarBaselines(2).x - mvarBaselines(1).x
    driftc.y = mvarBaselines(2).y - mvarBaselines(1).y
    driftc.z = mvarBaselines(2).z - mvarBaselines(1).z
End Property

Public Property Get induced() As Cartesian3D
    Dim i As Integer
    Dim workingvector As Cartesian3D
    Set induced = New Cartesian3D
    With induced
        For i = 1 To 4
            Set workingvector = BaselineAdjustedSample(i)
            .x = .x + workingvector.x / 4
            .y = .y + workingvector.y / 4
            If i > 2 Then
                .z = .z - workingvector.z / 4
            Else
                .z = .z + workingvector.z / 4
            End If
            Set workingvector = Nothing
        Next i
    End With
End Property

Public Property Get CorrectedSample(ByVal i As Integer) As Cartesian3D
    ' returns sample as corrected for angle and baseline adjusted
    Dim x As Double, y As Double, z As Double
    Dim workingvector As Cartesian3D
    
    Set workingvector = BaselineAdjustedSample(i)
    Set CorrectedSample = New Cartesian3D
    With CorrectedSample
        x = workingvector.x
        y = workingvector.y
        z = workingvector.z
    Select Case i
        Case 1
            .x = x
            .y = -y * mvarDirection
            .z = z * mvarDirection
        Case 2
            .x = y
            .y = x * mvarDirection
            .z = z * mvarDirection
        Case 3
            .x = -x
            .y = y * mvarDirection
            .z = z * mvarDirection
        Case 4
            .x = -y
            .y = -x * mvarDirection
            .z = z * mvarDirection
    End Select
    End With
    
    Set workingvector = Nothing
End Property

Public Property Get sum() As Cartesian3D
    Dim i As Integer
    Dim workingvector As Cartesian3D
    Set sum = New Cartesian3D
    
    With sum
    For i = 1 To 4
        Set workingvector = CorrectedSample(i)
        .x = .x + workingvector.x
        .y = .y + workingvector.y
        .z = .z + workingvector.z
    Next i
    End With
    Set workingvector = Nothing

End Property

Public Property Get SumUnitVectors() As Cartesian3D
    Dim i As Integer
    Dim workingvector As Cartesian3D
    Set SumUnitVectors = New Cartesian3D
    
    For i = 1 To 4
        Set workingvector = CorrectedSample(i)
        SumUnitVectors.x = SumUnitVectors.x + workingvector.UnitVectorX
        SumUnitVectors.y = SumUnitVectors.y + workingvector.UnitVectorY
        SumUnitVectors.z = SumUnitVectors.z + workingvector.UnitVectorZ
    Next i
    Set workingvector = Nothing

End Property

Public Property Get SumSqs() As Cartesian3D
    Dim i As Integer
    Dim workingvector As Cartesian3D
    Set SumSqs = New Cartesian3D
    
    With SumSqs
    For i = 1 To 4
        Set workingvector = CorrectedSample(i)
        .x = .x + workingvector.x ^ 2
        .y = .y + workingvector.y ^ 2
        .z = .z + workingvector.z ^ 2
    Next i
    End With
    Set workingvector = Nothing

End Property


Public Property Get Average() As Cartesian3D
    Dim i As Integer
    Dim workingvector As Cartesian3D
    
    Set workingvector = sum
    Set Average = New Cartesian3D
    
    
    With Average
        .x = workingvector.x / 4
        .y = workingvector.y / 4
        .z = workingvector.z / 4
    End With
    Set workingvector = Nothing
End Property

Public Property Get AverageMagnitude() As Double
    Dim workingvector As Cartesian3D
    
    Set workingvector = Average
    With workingvector
        AverageMagnitude = Sqr(.x ^ 2 + .y ^ 2 + .z ^ 2)
    End With
    Set workingvector = Nothing
End Property

Private Function CorrectedHolder(ByVal i As Integer) As Cartesian3D
    ' returns sample as corrected for angle and baseline adjusted
    Dim x As Double, y As Double, z As Double
    x = mvarHolder(i).x
    y = mvarHolder(i).y
    z = mvarHolder(i).z
    Set CorrectedHolder = New Cartesian3D
    With CorrectedHolder
    Select Case i
        Case 1
            .x = x
            .y = -y
            .z = z
        Case 2
            .x = y
            .y = x
            .z = z
        Case 3
            .x = -x
            .y = y
            .z = z
        Case 4
            .x = -y
            .y = -x
            .z = z
    End Select
    End With
End Function

Private Function AverageHolder() As Cartesian3D
    Dim i As Integer
    Dim workingvector As Cartesian3D
    Set AverageHolder = New Cartesian3D
    
    With AverageHolder
    For i = 1 To 4
        Set workingvector = CorrectedHolder(i)
        .x = .x + workingvector.x / 4
        .y = .y + workingvector.y / 4
        .z = .z + workingvector.z / 4
    Next i
    End With
    Set workingvector = Nothing
End Function


Public Property Get SigInduced() As Double
    ' SIGINDUCED measures rotational asymmetry of X,Y, & Z
    Dim inducedMag As Double
    
    inducedMag = induced.mag
    If inducedMag = 0 Then inducedMag = 0.000000001
    SigInduced = AverageMagnitude / inducedMag
End Property

Public Property Get SigHolder() As Double
    ' SIGHOLDER is sample moment/holder moment
    Dim HolderMag As Double
    HolderMag = HolderFVal
    If HolderMag = 0 Then HolderMag = 0.000000001
    
    SigHolder = AverageMagnitude / HolderMag
End Property

Public Property Get SigDrift() As Double
    ' SIGDRIFT  is sample moment/baseline drifts
    Dim DriftMag As Double
    
    DriftMag = driftc.mag
    If DriftMag = 0 Then DriftMag = 0.000000001
    SigDrift = AverageMagnitude / DriftMag
End Property

Public Property Get HolderFVal() As Double
    HolderFVal = AverageHolder.mag
End Property

Public Property Get Kappa() As Double
    Dim n As Integer
    Dim r As Double
    
    n = 4
    r = SumUnitVectors.mag
    If n = r Then
        Kappa = 0.000000001
    Else
        Kappa = (n - 1) / (n - r)
    End If
End Property


Public Property Get FischerSD() As Double
    ' returns theta-63
    ' this is circular SD from Fischer distribution
    
    FischerSD = 81 / Sqr(Kappa)
End Property
